package doABC.Trait;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import doABC.CpoolInfo;
import FlashReader.SWF;
import FlashReader.SwfTools;


public class Trait_Slot_Const extends SwfTools {
	
	private CpoolInfo cpool;
	private HashMap <Integer,String> flagsKind = new HashMap<Integer,String>();
	
	private int start=0;
	private int end=0;
	//struktory
	private int slot_id;
	private int type_name;
	private int vindex;
	private int vkind=-1;//u8 optional
	
	public Trait_Slot_Const(ByteBuffer bbuf, CpoolInfo cpool){
		super();
		initFlags();
		this.cpool = cpool;
		trait_slot_const(bbuf);
	}
	
	public void trait_slot_const(ByteBuffer bbuf){
		try{
		start = bbuf.position();
		slot_id = unsigned30int(bbuf);
		
		type_name =  unsigned30int(bbuf);

		vindex= unsigned30int(bbuf);

		if (vindex>0){
			vkind = unsigned30int(bbuf);
		}
		end = bbuf.position()-1;
		} catch (Exception e) {e.printStackTrace();}
	}

	public void initFlags(){
		flagsKind.put(0x03, "CONSTANT_Int");
		flagsKind.put(0x04, "CONSTANT_UInt");
		flagsKind.put(0x06, "CONSTANT_Double");
		flagsKind.put(0x01, "CONSTANT_Utf8");
		flagsKind.put(0x0B, "CONSTANT_True");
		flagsKind.put(0x0A, "CONSTANT_False");
		flagsKind.put(0x0C, "CONSTANT_Null");
		flagsKind.put(0x00, "CONSTANT_Undefined");
		flagsKind.put(0x08, "CONSTANT_Namespace");
		flagsKind.put(0x16, "CONSTANT_PackageNamespace");
		flagsKind.put(0x17, "CONSTANT_PackageInternalNs");
		flagsKind.put(0x18, "CONSTANT_ProtectedNamespace");
		flagsKind.put(0x19, "CONSTANT_ExplicitNamespace");
		flagsKind.put(0x1A, "CONSTANT_StaticProtectedNs");
		flagsKind.put(0x05, "CONSTANT_PrivateNs");
	}
	
	
	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		
			ArrayList<Byte> tmp1 =getUI32(slot_id);
			for (int i=0;i<tmp1.size();i++)
				result.add(tmp1.get(i));
		
			ArrayList<Byte> tmp2 =getUI32(type_name);
			for (int i=0;i<tmp2.size();i++)
				result.add(tmp2.get(i));
		
			ArrayList<Byte> tmp3 =getUI32(vindex);
			for (int i=0;i<tmp3.size();i++)
				result.add(tmp3.get(i));
		
		if (  vkind!=-1 && vindex>0){
			result.add((byte)vkind);
		}
		
		return result;
	}
	
	
	//getters
	
	public int getFlags(String flags) {
		return (Integer)getKeyFromValue(flagsKind, flags);
	}
	
	public int getSlot_id() {
		return slot_id;
	}

	public int getVindex() {
		return vindex;
	}

	
	public int getVkind() {
		return vkind;
	}
	
	public String getVkind_string() {
		return flagsKind.get(vkind);
	}

	public int getType_name() {
		return type_name;
	}
	
	public String getType_name_string() {
		return cpool.getMultiname(type_name);
	}
	
	//setters
	
	public void setSlot_id(int slot_id) {
		this.slot_id = slot_id;
	}
	
	public void setType_name(int type_name) {
		this.type_name = type_name;
	}
	
	public void setVkind(int vkind) {
		this.vkind = vkind;
	}
	
	public void setVindex(int vindex) {
		this.vindex = vindex;
	}
	
	//tostrings
	public String toString(){
		String wynik ="";
		wynik+="\n---#--- Trait_Slot_Const \n"+SWF.msgs.getString("Position")+": " + start + "\n";
		
		wynik+= "slot_id: " +slot_id +"\n";
		wynik+= "type_name: " +getType_name() +"\n";
		wynik+= "vindex: " +vindex +"\n";
		wynik+= "vkind: " +vkind +"\n";
		
		wynik+=SWF.msgs.getString("Position")+":  "+end +"\n---!!--- "+SWF.msgs.getString("end")+"\n";
		return wynik;
	}
	
	
	
	
	
}
